/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.PermittedTargets;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SelectionTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class UIQueryTasklet
extends Tasklet
implements UILog {
    private static final ClassId TASK_CLASSID = new ClassId(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = UIQueryTasklet.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task);
    private static final String TRACE_MASKT = "HUIQTSKT";
    private static final String TRACE_MASKF = "HUIQTSKF";
    private static final String TRACE_MASKD = "HUIQTSKD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;

    public void init(Object obj) throws TaskletException {
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UIQueryTasklet.service()");
        if (request.isInitialRequest()) {
            response.noAction();
        } else {
            String requestKey = (String)request.getData("request");
            Trace.trace(TRACE_MASKF, "   requestKey is [" + requestKey + "]");
            if (requestKey.equals("GetLaunchData")) {
                this.serviceGetLaunchData(request, response);
            } else if (requestKey.equals("GetUIBooks")) {
                this.serviceGetUIBooks(request, response);
            } else if (requestKey.equals("ToggleLock")) {
                this.serviceToggleLock(request, response);
            } else if (requestKey.equals("GetAllowedTasksMap")) {
                this.serviceGetAllowedTasksMap(request, response);
            } else {
                Trace.trace(TRACE_MASKF, "   Error, unknown request was received");
                response.noAction();
            }
        }
        Trace.trace(TRACE_MASKT, "<- UIQueryTasklet.service()");
    }

    private void serviceGetLaunchData(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UIQueryTasklet.serviceGetLaunchData()");
        String taskShortId = (String)request.getData("TaskShortId");
        String parentShortId = (String)request.getData("ParentShortId");
        Set targetShortIds = (Set)request.getData("TargetShortIds");
        int launchType = (Integer)request.getData("LaunchType");
        ShortObjectIdManager shortIdManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        ObjectId taskObjectId = null;
        if (launchType != 3) {
            taskObjectId = shortIdManager.getObjectId(taskShortId);
        }
        ObjectId parentObjectId = null;
        if (parentShortId != null) {
            parentObjectId = shortIdManager.getObjectId(parentShortId);
        }
        HashSet targetObjectIds = null;
        if (targetShortIds != null && targetShortIds.size() > 0) {
            targetObjectIds = new HashSet();
            Iterator iterator = shortIdManager.getObjectIds(targetShortIds).values().iterator();
            while (iterator.hasNext()) {
                targetObjectIds.add(iterator.next());
            }
        } else {
            Trace.trace(TRACE_MASKF, "   targetShortIds is null or empty");
        }
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        if (launchType == 3) {
            Iterator iterator = targetObjectIds.iterator();
            while (iterator.hasNext()) {
                ObjectId next = (ObjectId)iterator.next();
                if (!next.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? UIQueryTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) continue;
                taskObjectId = (ObjectId)mom.getProperty(next, "OpenTaskObjectId");
            }
        }
        if (taskObjectId == null) {
            Trace.trace(TRACE_MASKF, "   could not determine the task to launch");
        } else {
            UIInfo taskUIInfo = (UIInfo)mom.getProperty(taskObjectId, "UIInfo");
            response.setData("TaskUIInfo", taskUIInfo);
            String mergedKey = null;
            if (launchType == 2) {
                mergedKey = (String)mom.getProperty(taskObjectId, "MergedKey");
            }
            if (mergedKey == null) {
                response.setData("TaskObjectId", taskObjectId);
                response.setData("TargetTree", this.createTargetTree(targetObjectIds, parentObjectId, mom, null, true));
                response.setData("TaskClassName", mom.getProperty(taskObjectId, "PresentationTaskClassName"));
            } else {
                Task task;
                HashSet launchSet = new HashSet();
                response.setData("LaunchSet", launchSet);
                Set tasks = mom.getInventory(TASK_CLASSID);
                HashSet<Task> mergedTasks = new HashSet<Task>();
                Iterator iterator = tasks.iterator();
                while (iterator.hasNext()) {
                    task = (Task)iterator.next();
                    String nextMergedKey = task.getMergedKey();
                    if (nextMergedKey == null || !nextMergedKey.equals(mergedKey)) continue;
                    mergedTasks.add(task);
                }
                task = null;
                SelectionTreeNode root = null;
                boolean allowed = false;
                iterator = mergedTasks.iterator();
                while (iterator.hasNext() && !allowed) {
                    task = (Task)iterator.next();
                    root = this.createTargetTree(targetObjectIds, parentObjectId, mom, task, true);
                    Set permittedObjects = task.getPermittedObjects();
                    List leaves = root.getLeaves();
                    Iterator leavesIterator = leaves.iterator();
                    while (!allowed && leavesIterator.hasNext()) {
                        SelectionTreeNode next = (SelectionTreeNode)leavesIterator.next();
                        allowed = this.isObjectPermitted(permittedObjects, (ObjectId)next.getUserObject());
                        if (allowed) continue;
                        Trace.trace(TRACE_MASKD, "The targets are not valid for the task, try the next merged task.");
                        Trace.trace(TRACE_MASKD, "  task ObjectId is " + next.getUserObject());
                        Iterator iter = permittedObjects.iterator();
                        Trace.trace(TRACE_MASKD, "  permitted ObjectIds are: ");
                        while (iter.hasNext()) {
                            Trace.trace(TRACE_MASKD, "    " + iter.next());
                        }
                    }
                    if (!allowed) continue;
                    response.setData("MergedKey", mergedKey);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TaskObjectId", task.getObjectId());
                    map.put("TargetTree", root);
                    map.put("TaskClassName", task.getPresentationTaskClassName());
                    launchSet.add(map);
                }
                if (!allowed) {
                    response.setData("TaskObjectId", taskObjectId);
                    response.setData("TargetTree", this.createTargetTree(targetObjectIds, parentObjectId, mom, null, false));
                    response.setData("TaskClassName", mom.getProperty(taskObjectId, "PresentationTaskClassName"));
                }
            }
        }
        response.noAction();
        Trace.trace(TRACE_MASKT, "<- UIQueryTasklet.serviceGetLaunchData()");
    }

    private void serviceGetUIBooks(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIQueryTasklet.serviceGetUIBooks()");
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ClassId classId = new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = UIQueryTasklet.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower);
        Set towers = mom.getInventory(classId);
        ArrayList allBooks = new ArrayList();
        Iterator iterator = towers.iterator();
        while (iterator.hasNext()) {
            Tower tower = (Tower)iterator.next();
            List books = tower.getUIBooks();
            if (books.size() <= 0) continue;
            allBooks.addAll(books);
        }
        response.setData("UIBooks", allBooks);
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UIQueryTasklet.serviceGetUIBooks()");
    }

    private void serviceToggleLock(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIQueryTasklet.serviceToggleLock()");
        String shortIds = (String)request.getData("ShortId");
        ShortObjectIdManager shortIdManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        StringTokenizer tokens = new StringTokenizer(shortIds);
        while (tokens.hasMoreTokens()) {
            ManagedObject managedObject;
            ObjectId objectId = shortIdManager.getObjectId(tokens.nextToken());
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            managedObject.setLocked(!(managedObject = (ManagedObject)mom.get(objectId)).isLocked());
        }
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UIQueryTasklet.serviceToggleLock()");
    }

    private void serviceGetAllowedTasksMap(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIQueryTasklet.serviceGetAllowedTasksMap()");
        PermittedTargets permittedTargets = UIObjectsWriter.getUIObjectsWriter().getPermittedTargets();
        Map result = permittedTargets.getTaskToObjectMap();
        response.setData("TaskShortIdsMap", result);
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UIQueryTasklet.serviceGetAllowedTasksMap()");
    }

    private SelectionTreeNode createTargetTree(Set targetObjectIds, ObjectId parentObjectId, ManagedObjectManager mom, Task task, boolean checkPermissions) {
        Trace.trace(TRACE_MASKF, "-> UIQueryTasklet.createTargetTree()");
        SelectionTreeNode root = new SelectionTreeNode("Root");
        SelectionTreeNode group = null;
        if (parentObjectId == null) {
            group = root;
        } else {
            group = new SelectionTreeNode(parentObjectId);
            root.add(group);
        }
        if (targetObjectIds == null || targetObjectIds.size() == 0) {
            Trace.trace(TRACE_MASKF, "   targetObjectIds is null or empty");
        } else {
            Iterator iterator = targetObjectIds.iterator();
            while (iterator.hasNext()) {
                List children;
                ObjectId targetObjectId = (ObjectId)iterator.next();
                if (task != null && checkPermissions && (!checkPermissions || !this.isObjectPermitted(task.getPermittedObjects(), targetObjectId))) continue;
                SelectionTreeNode node = new SelectionTreeNode(targetObjectId);
                node.setSelected(true);
                group.add(node);
                if (!targetObjectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UIQueryTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup) || (children = (List)mom.getProperty(targetObjectId, "Children")) == null) continue;
                this.addChildrenToTree(node, children, mom, task, checkPermissions);
            }
        }
        root.dump();
        Trace.trace(TRACE_MASKF, "<- UIQueryTasklet.createTargetTree()");
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildrenToTree(SelectionTreeNode parentNode, List children, ManagedObjectManager mom, Task task, boolean checkPermissions) {
        Trace.trace(TRACE_MASKF, "-> UIQueryTasklet.addChildrenToTree()");
        UIObjectsReader reader = null;
        try {
            ShortObjectIdManager shortIdManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
            reader = new UIObjectsReader();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                String shortId;
                ObjectId nextObjectId = (ObjectId)iterator.next();
                if (task != null && checkPermissions && (!checkPermissions || !this.isObjectPermitted(task.getPermittedObjects(), nextObjectId)) || (shortId = shortIdManager.getShortId(nextObjectId)) == null) continue;
                try {
                    List list;
                    byte[] buffer = reader.getBuffer(shortId);
                    if (UIObjectsReader.isDeleted(buffer)) continue;
                    Trace.trace(TRACE_MASKF, "  add child " + nextObjectId);
                    SelectionTreeNode childNode = new SelectionTreeNode(nextObjectId);
                    parentNode.add(childNode);
                    if (!nextObjectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UIQueryTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup) || (list = (List)mom.getProperty(nextObjectId, "Children")) == null) continue;
                    this.addChildrenToTree(childNode, list, mom, task, checkPermissions);
                }
                catch (InvalidIdException exc) {}
            }
        }
        catch (Exception exc) {
            new FrameworkLog(UILog.logInfo, 1816, exc).log();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIQueryTasklet.addChildrenToTree()");
    }

    private boolean isObjectPermitted(Set permittedObjects, ObjectId objectId) {
        return permittedObjects.contains(objectId.getFullClassName());
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "Error in UIQueryTasklet.logException(): " + throwable);
        new FrameworkLog(UILog.logInfo, 1808, throwable).log();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

